function Item()
{
	this.name = "";
	this.type = "";
	this.icon = undefined;
	this.amount = 0;
	this.description = "";
	this.effect = undefined; // Use function goes here
	// Attributes
	this.attack = 0;
	this.hit = 0;
	this.defense = 0;
	this.evade = 0;
	this.mdefense = 0;
	this.mevade = 0;
	this.element = undefined;
}

// Retrieves item info from item.dat
Item.prototype.load = function(name)
{
	var file = OpenFile("item.dat");
	this.name = name;
	this.type = file.read(name + ":Type", "");
	this.icon = file.read(name + ":Icon", "");
	if (this.icon == "")
	{
		this.icon = undefined;
	}
	else
		this.icon = images.icons[this.icon];
	this.description = file.read(name + ":Description", "");
	this.attack = file.read(name + ":Attack", 0);
	this.hit = file.read(name + ":Hit", 0);
	this.defense = file.read(name + ":Defense", 0);
	this.evade = file.read(name + ":Evade", 0);
	this.mdefense = file.read(name + ":MDefense", 0);
	this.mevade = file.read(name + ":MEvade", 0);
	this.element = file.read(name + ":Element", "");
	if (this.element == "")
	{
		this.element = undefined;
	}
}

// Add an item to an array. If array is not specified, places it in system.items.
function addItem(name, amount, array)
{
	if (array == undefined)
	{
		array = system.items;
	}
	for (var i = 0; i < array.length; i ++)
	{
		if (array[i].name == name)
		{
			// Found item in array. Add amount to it.
			array[i].amount += amount;
			if (array[i].amount > 100)
			{
				array[i].amount = 100;
			}
			return true;
		}
	}
	// Create new item in array
	// Find an empty spot
	for (var i = 0; i < array.length; i ++)
	{
		if (array[i] == undefined)
		{
			// Found an empty spot
			array[i] = new Item();
			array[i].load(name);
			array[i].amount = amount;
			return true;
		}
	}
	// Append the item
	var i = array.length;
	array[i] = new Item();
	array[i].load(name);
	array[i].amount = amount;
	return true;
}

function checkItem(name, amount, array)
{
	if (array == undefined)
	{
		array = system.items;
	}
	for (var i = 0; i < array.length; i ++)
	{
		if (array[i].name == name)
		{
			if (array[i].amount >= amount)
			{
				return true;
			}
			else
				return false;
		}
	}
	return false;
}

// Removes amount of items from array. If array is not specified, uses system.items
function removeItem(name, amount, array)
{
	if (array == undefined)
	{
		array = system.items;
	}
	for (var i = 0; i < array.length; i ++)
	{
		if (array[i].name == name)
		{
			array[i].amount -= amount;
			if (array[i].amount == 0)
			{
				array[i] = undefined;
			}
			return true;
		}
	}
	return false;
}

var natural = new Item();
natural.attack = 0;
natural.hit = 0;
natural.defense = 0;
natural.evade = 0;
natural.mdefense = 0;
natural.mevade = 0;

var BigBlade = new Item();
BigBlade.name = "Big Blade";
BigBlade.attack = 12;
